
https://wiki.eclipse.org/Equinox/p2/Customizing_Metadata
http://help.eclipse.org/neon/index.jsp?topic=/org.eclipse.platform.doc.isv/guide/p2_actions_touchpoints.html

```
# add update sites
instructions.configure=\
 org.eclipse.equinox.p2.touchpoint.eclipse.addRepository(location:http${#58}//gnu-mcu-eclipse.netlify.com/v4-neon-updates,type:0,name:GNU MCU Eclipse Plug-ins);\
 org.eclipse.equinox.p2.touchpoint.eclipse.addRepository(location:http${#58}//gnu-mcu-eclipse.netlify.com/v4-neon-updates,type:1,name:GNU MCU Eclipse Plug-ins);
 
# eof
```

```
addRepository	

location, type, enabled	Adds the repository at location of type type to the list of known repositories. The repository will then be available when installing or updating the profile in the future. The enabled parameter takes a boolean value ("true" or "false") indicating whether the add repository should be enabled. The value of the location parameter must be a well-formed URI. The type parameter value must be the value of one of the IRepository.TYPE_* constants, Specifically, type "0" indicates a metadata repository, and type "1" indicates an artifact repository.

Example:

instructions.configure=org.eclipse.equinox.p2.touchpoint.eclipse.addRepository(location:http${#58}//download.eclipse.org/birt/update-site/2.5/,type:0,name:BIRT 2.5,enabled:true); \
  org.eclipse.equinox.p2.touchpoint.eclipse.addRepository(location:http${#58}//download.eclipse.org/birt/update-site/2.5/,type:1,name:BIRT 2.5,enabled:true);
```

The `removeRepository()` entries used before are not really necessary.

In principle it might be possible to remove older plug-ins with some actions here.

```
installBundle(bundle)

Installs a bundle artifact specified by the parameter bundle

uninstallBundle(bundle)

Uninstalls a bundle artifact with a bundle-id specified by the parameter bundle

installFeature(feature, featureId, version)

Installs the feature referenced by the parameter feature (matched against artifacts in the iu). The feature is installed with the id specified by the parameter featureId, or if this parameter has the value default, with the id specified in the artifact referenced by feature. The features is installed with the version specified in version, or with the version specified in the artifact referenced by the feature parameter if the version parameter has the value default

uninstallFeature(feature, featureId, version)

Uninstalls a feature. Parameters have the same meaning as for the command installFeature
```

```
instructions.install=\
org.eclipse.equinox.p2.touchpoint.eclipse.uninstallFeature(feature:xxx)
```

Tried this without success:

```
# instructions.install=\
# org.eclipse.equinox.p2.touchpoint.eclipse.uninstallFeature(feature:ilg.gnuarmeclipse.doc.user,featureId:default,version:default);
  
artifacts.0.classifier=osgi.bundle
artifacts.0.name=ilg.gnuarmeclipse.doc.user

instructions.install=\
 org.eclipse.equinox.p2.touchpoint.eclipse.uninstallBundle(bundle:${artifacts})
```

