/* RCS  $Id: alloc.h,v 1.2 1998/10/22 00:41:13 fb Exp $
--
-- SYNOPSIS
--      Macros for allocating memory.
-- 
-- DESCRIPTION
--	A somewhat nicer interface to malloc and calloc.
--	Here we standardise the calling convention with a common macro
--	interface.
-- 
-- AUTHOR
--      Dennis Vadura, dvadura@dmake.wticorp.com
--
-- WWW
--      http://dmake.wticorp.com/
--
-- COPYRIGHT
--      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
-- 
--      This program is NOT free software; you can redistribute it and/or
--      modify it under the terms of the Software License Agreement Provided
--      in the file <distribution-root>/readme/license.txt.
--
-- LOG
--      Use cvs log to obtain detailed change logs.
*/

#ifndef ALLOC_h
#define ALLOC_h

#define	usizeof(t)	(size_t)sizeof(t)

#define FREE(p)         free((char*)(p))
#define MALLOC(n, t)    (t*) malloc((unsigned int)(n)*usizeof(t))
#define CALLOC(n, t)    (t*) calloc((unsigned int)(n), usizeof(t))

#define TALLOC(p, n, t)	if ((p = CALLOC(n, t)) == (t*)0) {No_ram();}

#endif

