/* RCS  $Id: dchdir.c,v 1.2 1998/10/22 00:41:14 fb Exp $
--
-- SYNOPSIS
--      Change directory.
-- 
-- DESCRIPTION
--	Under DOS change the current drive as well as the current directory.
--
-- AUTHOR
--      Dennis Vadura, dvadura@dmake.wticorp.com
--
-- WWW
--      http://dmake.wticorp.com/
--
-- COPYRIGHT
--      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
-- 
--      This program is NOT free software; you can redistribute it and/or
--      modify it under the terms of the Software License Agreement Provided
--      in the file <distribution-root>/readme/license.txt.
--
-- LOG
--      Use cvs log to obtain detailed change logs.
*/

#ifdef MSDOS
#include <direct.h>
#include "extern.h"

PUBLIC int
dchdir(path)
char *path;
{
   int   res;

   res = chdir(path);

   if (res != -1 && path[1] == ':') {
      unsigned new_drive;

      /* for WIN32 just use the _chdrive library call */
      new_drive = (*path & ~0x20) - 'A' + 1;
#if	defined(__WATCOMC__)
      {
	 int total;

	 _dos_setdrive(new_drive, &total);
      }
#else
      _chdrive(new_drive);
#endif
   }

   return (res);
}
#endif
