#include "extern.h"
#include <version.h>
#include <host.h>

#ifdef HOST_WIN32
#include <windows.h>
#include <process.h>
#endif


/*
 *	Get default place of startup.mk
 */

char *Get_startup_file()
{
	char *s, *path;

	s = get_default_diab_directory();
	path = malloc(strlen(s)+20);
	strcpy(path, s);
	strcat(path, SEP_STR);
	strcat(path, "dmake");
	strcat(path, SEP_STR);
	strcat(path, "startup.mk");
	return path;
}


/*
 *	Get name of OS
 */

char *Get_os_name()
{
#if	defined(HOST_WIN32)
	int ret;
	OSVERSIONINFO verinfo;

	verinfo.dwOSVersionInfoSize = sizeof verinfo;
	ret = GetVersionEx(&verinfo);
	if(ret == 1 && verinfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		return "winnt";
	}
	return "win95";
#elif	defined(UNIX)
	return "unix";
#elif	defined(HOST_MSDOS) || defined(HOST_MSTNT) || defined(HOST_WIN16)
	return "msdos";
#elif	defined(HOST_OS2)
	return "os2";
#elif	defined(HOST_MPW68) || defined(HOST_MPWPPC)
	return "mpw";
#else
	return NULL;
#endif
}
