// Created on 15.09.2006
package biz.junginger.plugin.common;

import java.net.URL;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

import biz.junginger.newsfeed.eclipse.Logger;

public abstract class EclipseUiBrowser
{
    EclipseUiBrowser() {}

    public static EclipseUiBrowser create(Display display) {
        try {
            Class clazz = Class.forName("biz.junginger.plugin.common.EclipseUiBrowserImpl");
            EclipseUiBrowser browser = (EclipseUiBrowser) clazz.newInstance();
            browser.setDisplay(display);
            return browser;
        } catch (Throwable ex) {
            Logger.error("Seems we have no BrowserSupport here", ex);
            return null;
        }
    }
    
    public abstract void setDisplay(Display display);

    public abstract void createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException;

    public abstract void openBrowser(String browserId, URL url) throws PartInitException;

    public abstract void openSharedBrowser(URL url) throws PartInitException;

    public abstract void openExternalBrowser(URL url) throws PartInitException;

    public abstract boolean isInternalWebBrowserAvailable();
}
