// Created on 15.09.2006
package biz.junginger.plugin.common;
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - An error message dialog opens, when no needed external browser is configured
 */

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

import biz.junginger.newsfeed.ExceptionHistory;
import biz.junginger.newsfeed.eclipse.Logger;

class EclipseUiBrowserImpl extends EclipseUiBrowser
{
    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();

    private Display display;

    private Map browserMap = new HashMap();

    public void createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException
    {
        browserSupport.createBrowser(style, browserId, name, tooltip);
    }

    public void openBrowser(final String browserId, final URL url)
    {
        display.asyncExec(new Runnable()
        {
            public void run()
            {
                if (!isInternalWebBrowserAvailable()) {
                    // E.g. on Solaris, there is not internal browser support
                    openExternalBrowser(url);
                    return;
                }
                try {
                    IWebBrowser browser = (IWebBrowser) browserMap.get(browserId);
                    if (browser == null) {
                        browser = browserSupport.createBrowser(browserId);
                        if (browserId != null) {
                            browserMap.put(browserId, browser);
                        }
                    }
                    browser.openURL(url);
                } catch (Throwable ex) {
                    String msg = "Could not open browser (async)";
                    // TODO remove dependency to ExceptionHistory an Logger
                    // here?
                    Logger.error(ex);
                    ExceptionHistory.getInstance().add(ex, msg);
                }
            }

        });
    }

    public void openSharedBrowser(URL url)
    {
        // browserSupport.createBrowser("org.eclipse.ui.browser").openURL(url);
        openBrowser("org.eclipse.ui.browser", url);
    }

    public void openExternalBrowser(final URL url)
    {
        display.asyncExec(new Runnable()
        {
            public void run()
            {
                try {
                    browserSupport.getExternalBrowser().openURL(url);
                } catch (Throwable ex) {
                	MessageDialog.openError(null, "No external browser configured", "Could not open a Web Browser " +
                    		"because there are none configured. Check the Web Browser preferences.");
                    String msg = "Could not open external browser (async)";
                    // TODO remove dependency to ExceptionHistory an Logger
                    // here?
                    //Logger.error(ex);
                    ExceptionHistory.getInstance().add(ex, msg);
                }
            }
        });
    }

    public boolean isInternalWebBrowserAvailable()
    {
        try {
            boolean available = browserSupport.isInternalWebBrowserAvailable();
            return available;
        } catch (Throwable ex) {
            String msg = "Could not check isInternalWebBrowserAvailable";
            Logger.error(ex);
            ExceptionHistory.getInstance().add(ex, msg);
            return false;
        }
    }

    public void setDisplay(Display display)
    {
        this.display = display;
    }

}
