// Created on 10.04.2005
package biz.junginger.plugin.common;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;

import biz.junginger.newsfeed.eclipse.Logger;

public class MyPreferencesAction extends Action implements ActionFactory.IWorkbenchAction
{
    private String pageId; 
    private IWorkbenchWindow workbenchWindow;

    public MyPreferencesAction()
    {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public MyPreferencesAction(IWorkbenchWindow window)
    {
        super("Preferences"); 
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        setText("Preferences");
    }

    public void run()
    {
        if (workbenchWindow == null) return;
        if(pageId==null)
        {
            Logger.error("No page ID set");
            return;
        }
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, pageId, null, null);
        dialog.open();
    }

    public void dispose() {
        workbenchWindow = null;
    }

    public void setPageId(String pluginId)
    {
        this.pageId = pluginId;
    }

}
