// Created on 18.06.2005
package biz.junginger.plugin.common;

import java.lang.reflect.Method;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;

import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.eclipse.OpenUrlAction;

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - changed printStackTrace() to logged error
 */

public class PluginUtils
{
    /** @return null prior to Eclipse 3.1 */
    public static IAction createPreferencesAction(String pageId)
    {
        IAction prefAction=null;
        try     // Only Eclipse 3.1        
        {
            Class class1 = PluginUtils.class.getClassLoader().loadClass("biz.junginger.plugin.common.MyPreferencesAction");
            prefAction = (IAction) class1.newInstance();
            
            Class[] parameterTypes= {String.class};
            Method setPageId = class1.getMethod("setPageId", parameterTypes);
            Object[] args= {pageId};
            setPageId.invoke(prefAction, args);
        }
        catch(Throwable ex) {
        	Logger.error("Could not create prefereces.", ex); //$NON-NLS-1$
        }
        return prefAction;
    }
    
    public static MenuManager createRateMenu(UrlOpener urlOpener, String pluginIdCentral, String pluginIdInfo)
    {
        MenuManager rateMenu=new MenuManager("Rate this plugin at");
        String urlCentral="http://www.eclipseplugincentral.com/Web_Links-index-req-viewlink-cid-"+pluginIdCentral+".html";
        String urlInfo="http://eclipse-plugins.info/eclipse/plugin_details.jsp?id="+pluginIdInfo;
        
        rateMenu.add(new OpenUrlAction(urlOpener, urlInfo,"eclipse-plugins.info"));
        rateMenu.add(new OpenUrlAction(urlOpener, urlCentral,"eclipseplugincentral.com"));
        return rateMenu;
    }    

}
