// Created on 01.02.2008
package biz.junginger.newsfeed;

import java.io.File;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;
import biz.junginger.newsfeed.FeedProcessorQueue.Result;
import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelSettings;
import biz.junginger.newsfeed.net.MyFileCache;

/**
 * @author Markus Oliver Junginger
 */
public class FeedProcessorQueueTest extends TestCase
{
    // Sorry, Yahoo
    private static String TEST_FEED_URL = "http://rss.news.yahoo.com/rss/topstories";

    private FeedProcessorQueue feedProcessorQueue;

    private MyFileCache cache;

    private File testDir;

    private ExceptionHistory exHistory;

    private static final int NUMBER_OF_THREADS = 100;

    protected void setUp() throws Exception
    {
        testDir = new File("./temp-test/");
        testDir.mkdir();
        cache = new MyFileCache(testDir);
        cache.clearAll();
        FeedProcessor processor = new FeedProcessor(cache);
        feedProcessorQueue = new FeedProcessorQueue(processor);
        exHistory = ExceptionHistory.getInstance();
    }

    protected void tearDown() throws Exception
    {
        cache.clearAll();
        testDir.delete();
    }

    public void testMultiThreading()
    {
        int submitted = 0;
        System.out.println("All started");
        int resultCount = 0;
        int lastResult = 0;
        while (true) {
            int active = feedProcessorQueue.getActiveThreadCount();
            if (submitted < NUMBER_OF_THREADS && active < 10) {
                int num = Math.min(5, NUMBER_OF_THREADS - submitted);
                for (int i = 0; i < num; i++) {
                    ChannelSettings settings = new ChannelSettings();
                    settings.setUrl(TEST_FEED_URL);
                    feedProcessorQueue.submitWork(settings);
                }
            }

            while (true) {
                Result result = feedProcessorQueue.dequeue();
                if (result != null) {
                    resultCount++;
                } else {
                    break;
                }
            }
            if (resultCount != lastResult) {
                System.out.print(resultCount + "..");
                lastResult = resultCount;
            }
            int exCount = exHistory.getEntriesCopy().size();
            if (resultCount == NUMBER_OF_THREADS || exCount != 0) {
                break;
            }
            try {
                Thread.sleep(100);
            } catch (InterruptedException ex) {
            	Logger.error("Thread was interrupted.", ex); //$NON-NLS-1$
            }
        }
        List exCount = exHistory.getEntriesCopy();
        Iterator iterator = exCount.iterator();
        while (iterator.hasNext()) {
        	Logger.error("Error info: " + iterator.next().toString()); //$NON-NLS-1$
        }
        assertEquals(0, exCount.size());
        assertEquals(NUMBER_OF_THREADS, resultCount);
    }

}
