// Created on 15.09.2006
package biz.junginger.newsfeed;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;

import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.eclipse.prefs.PrefsConstants;
import biz.junginger.plugin.common.EclipseUiBrowser;
import biz.junginger.plugin.common.UrlOpener;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class BrowserDelegate implements UrlOpener
{
    public static String SINGLE_BROWSER_ID = "biz.junginger.newsfeed.browser";

    private EclipseUiBrowser eclipseUiBrowser;

    private final IPreferenceStore preferenceStore;

    public BrowserDelegate(IPreferenceStore preferenceStore)
    {
        this.preferenceStore = preferenceStore;
    }

    public void openUrl(String url) throws IOException
    {
        String browserPrefs = preferenceStore.getString(PrefsConstants.BROWSER);
        if (PrefsConstants.VALUE_BROWSER_CUSTOM.equals(browserPrefs)) {
            // Map old value
            browserPrefs = PrefsConstants.VALUE_BROWSER_EXTERNAL;
        }
        try {
            tryOpenUrlWithEclipse(browserPrefs, url);
        } catch (MalformedURLException mal) {
            throw mal;
        } catch (Throwable th) {
            String errInfo = "Could not open eclipse browser (setting " + browserPrefs + ")";
            ExceptionHistory.getInstance().add(th, errInfo);
        }
    }

    private void logOpened(String browserName)
    {
		if(Logger.getDebugMode() > 0){
			Logger.info("RSS View opened browser with " + browserName);
		}
    }

    private void tryOpenUrlWithEclipse(String browserPrefs, String url) throws PartInitException, MalformedURLException
    {
        if (PrefsConstants.VALUE_BROWSER_EXTERNAL.equals(browserPrefs)) {
            ensureEclipseUiBrowserInited();
            eclipseUiBrowser.openExternalBrowser(new URL(url));
        } else if (PrefsConstants.VALUE_BROWSER_INTERNAL_SINGLE.equals(browserPrefs)) {
            ensureEclipseUiBrowserInited();
            eclipseUiBrowser.openBrowser("SINGLE_BROWSER_ID", new URL(url));
        } else if (PrefsConstants.VALUE_BROWSER_INTERNAL_SHARED.equals(browserPrefs)) {
            ensureEclipseUiBrowserInited();
            eclipseUiBrowser.openSharedBrowser(new URL(url));
        } else if (PrefsConstants.VALUE_BROWSER_INTERNAL_MULTI.equals(browserPrefs)) {
            ensureEclipseUiBrowserInited();
            eclipseUiBrowser.openBrowser(null, new URL(url));
        } else {
            throw new RuntimeException("Unexpected browser setting: " + browserPrefs);
        }
        logOpened(browserPrefs);
    }

    private void ensureEclipseUiBrowserInited()
    {
        if (eclipseUiBrowser == null) {
            Display display = Display.getDefault();
            if (display == null) {
                throw new RuntimeException("Internal error: no display available in " + this);
            }
            eclipseUiBrowser = EclipseUiBrowser.create(display);
            if (eclipseUiBrowser == null) {
                String info = "Eclipse browser could not be created - check if your Eclipse version has browser support (V3.1 or higher)";
                throw new RuntimeException(info);
            }
        }
    }

}
