package biz.junginger.newsfeed;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelSettings;
import biz.junginger.newsfeed.util.MapOfLists;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ExceptionHistory {
	private static ExceptionHistory instance;
	
	private List entries; 
	private MapOfLists urlMap;
	public static final String NO_URL_KEY="(No URL)";
	
	protected ExceptionHistory() {
		entries=new ArrayList();
		urlMap=new MapOfLists();
	}

	public static synchronized ExceptionHistory getInstance() {
		if(instance==null) {
			instance=new ExceptionHistory();
		}
		return instance;
	}
	
	public synchronized List getEntriesCopy() {
		return new ArrayList(entries);
	}

	public synchronized void add(Throwable th, String additionalInfo) {
		add(th,additionalInfo, null);
	}
	public synchronized void add(Throwable th, String additionalInfo, ChannelSettings channelSettings) {
		Entry entry = new Entry();
		entry.setThrowable(th);
		entry.setAdditionalInfo(additionalInfo);
		entry.setChannelSettings(channelSettings);
		entry.setOccured(new Date());
		entries.add(entry);
		
		String key;
		if(channelSettings!=null && channelSettings.getUrl()!=null) {
			key=channelSettings.getUrl();
		} else {
			key=NO_URL_KEY;
		}
		urlMap.addToList(key, entry);
		logAdded(entry);
	}
	
	private void logAdded(Entry entry) {
		String msg = "[RSS View] Added to exception history: ";
		if(entry.getAdditionalInfo()!=null) {
			msg+="("+entry.getAdditionalInfo()+")";
		}
		if(entry.getThrowable()!=null) {
			msg+="("+entry.getThrowable().getMessage()+")";
		}
		if(entry.getOccured()!=null) {
			msg+="("+entry.getOccured()+")";
		}
		Logger.info(msg, entry.getThrowable());
	}
	
	public Map getUrlStringMapCopy() {
		return urlMap.getMapCopy();
	}

	public static class Entry {
		private Throwable throwable;
		private String additionalInfo;
		private Date occured;
		private ChannelSettings channelSettings;
		
		public String getAdditionalInfo() {
			return additionalInfo;
		}
		public void setAdditionalInfo(String additionalInfo) {
			this.additionalInfo = additionalInfo;
		}
		public Date getOccured() {
			return occured;
		}
		public void setOccured(Date occured) {
			this.occured = occured;
		}
		public Throwable getThrowable() {
			return throwable;
		}
		public void setThrowable(Throwable throwable) {
			this.throwable = throwable;
		}
		public ChannelSettings getChannelSettings() {
			return channelSettings;
		}
		public void setChannelSettings(ChannelSettings channelSettings) {
			this.channelSettings = channelSettings;
		}
		public String toString() {
		    String str="";
		    if(channelSettings!=null) {
		        str+="[URL: "+channelSettings.getUrl()+"]";
		    }
            if(throwable!=null) {
                str+="[Ex: "+throwable.getMessage()+"]";
            }
            if(additionalInfo!=null) {
                str+="[Info: "+additionalInfo+"]";
            }
		    return str; 
		}
		
	}

}
