// Created on 18.02.2006
package biz.junginger.newsfeed;

import java.util.Comparator;
import java.util.Date;

import biz.junginger.newsfeed.model.ChannelCommon;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class RelevantDateComparator implements Comparator
{
    public int compare(Object o1, Object o2)
    {
        if(!(o1 instanceof ChannelCommon) || !(o2 instanceof ChannelCommon)) return 0;
        Date d1=((ChannelCommon)o1).getRelevantDate();
        Date d2=((ChannelCommon)o2).getRelevantDate();
        if(d1==null && d2==null) return 0;
        if(d1==null) return 1;
        if(d2==null) return -1;
        return -d1.compareTo(d2);
    }
}