package biz.junginger.newsfeed;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelContent;
import biz.junginger.newsfeed.model.ChannelSettings;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class TemplateUrlListComparator implements Comparator
{
    private final List templateList;

    public TemplateUrlListComparator(List list)
    {
        templateList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            templateList.add(getUrlString(next));
        }
    }

    private String getUrlString(Object obj)
    {
        if (obj instanceof String) {
            return (String) obj;
        } else if (obj instanceof ChannelSettings) {
            return ((ChannelSettings) obj).getUrl();
        } else if (obj instanceof ChannelContent) {
            return ((ChannelContent) obj).getSourceUrl();
        } else if (obj == null) {
            return null;
        } else {
            throw new IllegalStateException("Unexpected type: " + obj.getClass());
        }
    }

    public int compare(Object o1, Object o2)
    {
        int i1 = templateList.indexOf(getUrlString(o1));
        int i2 = templateList.indexOf(getUrlString(o2));

        int diff = i1 - i2;
        if (diff == 0) {
            Logger.error("RSS View TemplateListComparator error: " + i1 + ", " + i2);
        }
        return diff;
    }
}