// Created on 17.02.2006
package biz.junginger.newsfeed;

import biz.junginger.newsfeed.model.ChannelCommon;
import biz.junginger.newsfeed.util.StringUtils;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class TooltipTextCreator
{
    private int width;
    private int maxLines;
    
    public TooltipTextCreator() {
        width=70;
        maxLines = 15;
    }

    public String createPlainText(ChannelCommon item, boolean showHeadline)
    {
        String description = item.getDescription();
        if(description!=null && description.length()>0)
        {
            description=StringUtils.convertHtmlToPlainText(description);
            return reformatText(description, width, maxLines);
         }

        return "";
    }


    /**
     * @param rssItem
     * @param description
     * @return
     */
    private String reformatText(String description, int width, int maxLines)
    {
        StringBuffer buffer=new StringBuffer(description);
        int len=description.length();
        int lines=0;
        
        int lastSpace=-1;
        int lineLen=0;
        for(int i=0;i<len;i++)
        {
            char c = buffer.charAt(i);
            lineLen++;
            if(c!=10 && c!=13 && c<' ')
            {
                c=' ';
                buffer.setCharAt(i, ' ');
            }
            if(c==' ') lastSpace=i;
            boolean manualBreak=false;
            if(c==10 || c==13) {
                lastSpace=i;
                manualBreak=true;
            }
            if((lineLen>width || manualBreak) && lastSpace!=-1)
            {
                lines++;
                if(lines>=maxLines) {
                    return buffer.substring(0, lastSpace)+"\n[...]";
                }
                buffer.setCharAt(lastSpace, '\n');
                lineLen=i-lastSpace;
                lastSpace=-1;

            }
        }
        return buffer.toString();
    }

    public void setWidth(int width)
    {
        this.width = width;
    }

    public void setMaxLines(int maxLines)
    {
        this.maxLines = maxLines;
    }


}
