// Created on 19.02.2006
package biz.junginger.newsfeed.eclipse;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.preference.IPreferenceStore;

import biz.junginger.newsfeed.eclipse.prefs.PrefsConstants;
import biz.junginger.newsfeed.model.ChannelCommon;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ChannelFilter
{

    private final IPreferenceStore preferences;

    public ChannelFilter(IPreferenceStore preferenceStore)
    {
        this.preferences = preferenceStore;
    }

    public List filterChannelItems(List list)
    {
        boolean active = preferences.getBoolean(PrefsConstants.FILTER_ACTIVE);
        if(!active) {
            return list;
        }
        
        int items = preferences.getInt(PrefsConstants.FILTER_ITEMS_PER_FEED);
        int minutes = preferences.getInt(PrefsConstants.FILTER_MINUTES);
        boolean timeActive = preferences.getBoolean(PrefsConstants.FILTER_TIME_ACTIVE);
        long time = preferences.getLong(PrefsConstants.FILTER_TIME);

        List filtered=new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChannelCommon item = (ChannelCommon) iterator.next();
            boolean keep=true;
            if(minutes>0) {
                keep=checkKeepItemMinutes(item,minutes);
            }
            if(keep && timeActive) {
                keep=checkKeepItemTime(item, time);
            }
            
            if(keep) filtered.add(item);
            if(items>0 && filtered.size()>=items) {
                break;
            }
            
        }
        return filtered;
    }

    private boolean checkKeepItemTime(ChannelCommon item, long time)
    {
        Date date=item.getRelevantDate();
        if(date==null) {
            return true;
        }
        return date.getTime()>time;
    }

    private boolean checkKeepItemMinutes(ChannelCommon item, int minutes)
    {
        Date date=item.getRelevantDate();
        if(date==null) {
            return true;
        }
        long age = System.currentTimeMillis()-date.getTime();
        return (age/1000/60)<minutes;
    }


}
