package biz.junginger.newsfeed.eclipse;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import biz.junginger.newsfeed.model.ChannelModel;

/**
 * Just a small bootstrap class that basically starts the controller.
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - created init() function to avoid plugin activation on startup
*/

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class FeedPlugin extends AbstractUIPlugin
{
    public final static  String ID = "biz.junginger.rss.eclipse.RssPlugin";
    
    // The shared instance.
    private static FeedPlugin plugin;

    private BundleContext bundleContext;

    private ChannelModel model;

    private FeedPluginController controller;

    public FeedPlugin()
    {
        if (plugin != null) {
            Logger.error("RSS View: Static plugin instance is not null initially");
        }
        plugin = this;
    }
    
    public static FeedPlugin getDefault()
    {
        return plugin;
    }

    /** This method is called upon plug-in activation */
    public void start(BundleContext context) throws Exception
    {
        super.start(context);
        this.bundleContext = context;
    }
    
    private void init() throws Exception
    {
    	if(model == null){
    		model = new ChannelModel();	
    	}
    	if(controller == null){
    		controller = new FeedPluginController(this, model);
    	}
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception
    {
    	if(controller != null){
    		controller.stop();
    	}
        super.stop(context);
    }

    public BundleContext getBundleContext()
    {
        return bundleContext;
    }

    public FeedPluginController getController()
    {
    	try {
			init();
		} catch (Exception e) {
			Logger.error("Controller initialization failed.", e); //$NON-NLS-1$
		}
        return controller;
    }

    public ChannelModel getModel()
    {
    	try {
			init();
		} catch (Exception e) {
			Logger.error("Controller initialization failed.", e); //$NON-NLS-1$
		}
        return model;
    }

}
