// Created on 19.02.2006
package biz.junginger.newsfeed.eclipse;

import java.text.DateFormat;
import java.util.Date;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import biz.junginger.newsfeed.eclipse.prefs.PrefsConstants;
import biz.junginger.newsfeed.util.DateUtils;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class FilterAction extends Action {
    
    private final IPreferenceStore preferenceStore;
    private Menu menu;
    private MenuItem itemsPerFeed1MenuItem;
    private MenuItem itemsPerFeed2MenuItem;
    private MenuItem itemsPerFeed3MenuItem;
    private MenuItem itemsPerFeed5MenuItem;
    private MenuItem itemsPerFeed7MenuItem;
    private MenuItem itemsPerFeed10MenuItem;
    private MenuItem age1HourMenuItem;
    private MenuItem age2HoursMenuItem;
    private MenuItem age4HoursMenuItem;
    private MenuItem age8HoursMenuItem;
    private MenuItem age24HoursMenuItem;
    private MenuItem age1WeekMenuItem;
    private MenuItem activeMenuItem;
//	private MenuItem addAllManualMenuItem;
	private MenuItem timeMenuItem;
//	private MenuItem addCurrentManualMenuItem;
    
    private DateFormat dateFormat;
    private DateFormat dateFormatToday;
    private MenuItem timeUpdateMenuItem;

    public FilterAction(Composite parent, IPreferenceStore preferenceStore)
    {
        this.preferenceStore = preferenceStore;
        setImageDescriptor(ImageBank.getInstance().getImageDescriptor(ImageBank.FILTER));
        setToolTipText("Filter");
        
        dateFormat=DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);
        dateFormatToday=DateFormat.getTimeInstance(DateFormat.SHORT);
        
        menu = new Menu(parent);
        activeMenuItem=createMenuItem("Filters active", PrefsConstants.FILTER_ACTIVE, null);
        new MenuItem(menu,SWT.SEPARATOR);
        createTimeMenuItems();
        new MenuItem(menu,SWT.SEPARATOR);
        createItemsPerFeedMenuItems();
        new MenuItem(menu,SWT.SEPARATOR);
        createMinutesMenuItems();

//        addAllManualMenuItem = createMenuItem("Add all to filter", keyMinutes, 60);
//        addCurrentManualMenuItem = createMenuItem("Add current to filter", keyMinutes, 60);
        updateSelection();
        
        IMenuCreator creator = createMenuCreator();
        setMenuCreator(creator);
    }

    private void createTimeMenuItems()
    {
        timeMenuItem = new MenuItem(menu, SWT.CHECK|SWT.SINGLE);
        timeMenuItem.setText("Newer than current time");
        timeMenuItem.addSelectionListener(new SelectionAdapter() {

            public void widgetSelected(SelectionEvent e)
            {
                boolean on = !preferenceStore.getBoolean(PrefsConstants.FILTER_TIME_ACTIVE);
                preferenceStore.setValue(PrefsConstants.FILTER_TIME_ACTIVE, on);
                long time;
                if(on) {
                    time=System.currentTimeMillis();
                    ensureFilterActive();
                } else {
                    time=0;
                }
                preferenceStore.setValue(PrefsConstants.FILTER_TIME, time);                
                updateSelection();
            }
            
        });
        
        timeUpdateMenuItem = new MenuItem(menu, SWT.SINGLE);
        timeUpdateMenuItem.setText("Set to current time");
        timeUpdateMenuItem.addSelectionListener(new SelectionAdapter() {

            public void widgetSelected(SelectionEvent e)
            {
                setTimeFilterToNow();
            }
        });
    }

    void setTimeFilterToNow()
    {
        long time=System.currentTimeMillis();
        preferenceStore.setValue(PrefsConstants.FILTER_TIME, time);
        preferenceStore.setValue(PrefsConstants.FILTER_TIME_ACTIVE, true);
        ensureFilterActive();
        updateSelection();
    }

    private void createMinutesMenuItems()
    {
        String keyMinutes= PrefsConstants.FILTER_MINUTES;
        age1HourMenuItem = createMenuItem("1 hour", keyMinutes, 60);
        age2HoursMenuItem = createMenuItem("2 hours", keyMinutes, 2*60);
        age4HoursMenuItem = createMenuItem("4 hours", keyMinutes, 4*60);
        age8HoursMenuItem = createMenuItem("8 hours", keyMinutes, 8*60);
        age24HoursMenuItem = createMenuItem("24 hours", keyMinutes, 24*60);
        age1WeekMenuItem = createMenuItem("1 week", keyMinutes, 7*24*60);
    }

    private void createItemsPerFeedMenuItems()
    {
        String keyItemsPerFeed = PrefsConstants.FILTER_ITEMS_PER_FEED;
        itemsPerFeed1MenuItem=createMenuItem("1 item per feed", keyItemsPerFeed, 1);
        itemsPerFeed2MenuItem=createMenuItem("2 items per feed", keyItemsPerFeed, 2);
        itemsPerFeed3MenuItem=createMenuItem("3 items per feed", keyItemsPerFeed, 3);
        itemsPerFeed5MenuItem=createMenuItem("5 items per feed", keyItemsPerFeed, 5);
        itemsPerFeed7MenuItem=createMenuItem("7 items per feed", keyItemsPerFeed, 7);
        itemsPerFeed10MenuItem=createMenuItem("10 items per feed", keyItemsPerFeed, 10);
    }

    private IMenuCreator createMenuCreator()
    {
        IMenuCreator creator = new IMenuCreator() {
            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
            
        };
        return creator;
    }

    //TODO call it
    public void dispose() {
        menu.dispose();
    }

    private MenuItem createMenuItem(String text, String key, Object value)
    {
        MenuItem  item= new MenuItem(menu, SWT.CHECK|SWT.SINGLE);
        item.setText(text);
        item.addSelectionListener(new MySelectionAdapter(key,value));
        return item;
    }

    private MenuItem createMenuItem(String text, String key, int value)
    {
        return createMenuItem(text, key, new Integer(value));
    }

    public void run() {
        handleToggleActive();
    }
    
    private class MySelectionAdapter extends SelectionAdapter {
        private String key;
        private Object value;

        MySelectionAdapter(String key, Object value){
            this.key = key;
            this.value = value;
        }

        public void widgetSelected(SelectionEvent e) {
            handleNewSelection(key, value);
        }
        
    }
    
    private void updateSelection() {
        boolean active = preferenceStore.getBoolean(PrefsConstants.FILTER_ACTIVE);
        activeMenuItem.setSelection(active);
        
        boolean timeActive = preferenceStore.getBoolean(PrefsConstants.FILTER_TIME_ACTIVE);
        timeMenuItem.setSelection(timeActive);
        long millis=preferenceStore.getLong(PrefsConstants.FILTER_TIME);
        setTimeMenuItemText(millis);
        timeUpdateMenuItem.setEnabled(timeActive);

        int items = preferenceStore.getInt(PrefsConstants.FILTER_ITEMS_PER_FEED);
        itemsPerFeed1MenuItem.setSelection(items==1);
        itemsPerFeed2MenuItem.setSelection(items==2);
        itemsPerFeed3MenuItem.setSelection(items==3);
        itemsPerFeed5MenuItem.setSelection(items==5);
        itemsPerFeed7MenuItem.setSelection(items==7);
        itemsPerFeed10MenuItem.setSelection(items==10);

        int minutes = preferenceStore.getInt(PrefsConstants.FILTER_MINUTES);
        age1HourMenuItem.setSelection(minutes==60);
        age2HoursMenuItem.setSelection(minutes==2*60);
        age4HoursMenuItem.setSelection(minutes==4*60);
        age8HoursMenuItem.setSelection(minutes==8*60);
        age24HoursMenuItem.setSelection(minutes==24*60);
        age1WeekMenuItem.setSelection(minutes==7*24*60);
    }
    
    private void handleNewSelection(String key, Object value)
    {
        if(PrefsConstants.FILTER_ACTIVE.equals(key)) {
            handleToggleActive();
            return;
        }
        if(value instanceof Integer) {
            int newValue = ((Integer)value).intValue();
            int old = preferenceStore.getInt(key);
            if(newValue==old) newValue=0;
            preferenceStore.setValue(key,newValue);
            if(newValue!=0) {
                ensureFilterActive();
            }
        } else {
            throw new IllegalArgumentException("Value: "+value);
        }
        updateSelection();
    }

    private void ensureFilterActive()
    {
        boolean active= preferenceStore.getBoolean(PrefsConstants.FILTER_ACTIVE);
        if(!active) {
            preferenceStore.setValue(PrefsConstants.FILTER_ACTIVE, true);
        }
    }

    private void handleToggleActive()
    {
        boolean old = preferenceStore.getBoolean(PrefsConstants.FILTER_ACTIVE);
        preferenceStore.setValue(PrefsConstants.FILTER_ACTIVE, !old);
        updateSelection();
    }

    private void setTimeMenuItemText(long millis)
    {
        if(millis!=0) {
            DateFormat format;
            if(DateUtils.isToday(millis)) {
                format=dateFormatToday;
            } else {
                format=dateFormat;
            }
            String dateStr = format.format(new Date(millis));
            timeMenuItem.setText("Newer than "+dateStr);
        } else {
            timeMenuItem.setText("Newer than current time");
        }
    }

}
