// Created on 18.03.2005
package biz.junginger.newsfeed.eclipse;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;


/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ImageBank
{
    public static final String TITLE="/icons/rss.gif";
    public static final String TITLE_GRAY="/icons/rss-gray.gif";
    public static final String RELOAD="/icons/sync.gif";
    public static final String NEWS="/icons/news.gif";
    public static final String CHECKBOX_ON="/icons/checkbox_on.gif";
    public static final String CHECKBOX_OFF="/icons/checkbox_off.gif";
    public static final String MONITOR_VIEW="/icons/monitor_view.gif";
    public static final String FILTER="/icons/filter.gif";
    public static final String EXPAND="/icons/expand16.gif";
    public static final String COLLAPSE="/icons/collapse16.gif";
    public static final String TIME_FILTER="/icons/time-filter.gif";
    
    Map descriptorMap;
    
    private static ImageBank instance;
    
    public synchronized static ImageBank getInstance()
    {
        if(instance==null) instance=new ImageBank();
        return instance;
    }
    
    public ImageBank()
    {
        descriptorMap=new HashMap();
    }
    
    public Image createImage(String resource)
    {
        ImageDescriptor descriptor=getImageDescriptor(resource);
        return descriptor.createImage();
    }

    public ImageDescriptor getImageDescriptor(String resource)
    {
        ImageDescriptor descriptor=(ImageDescriptor) descriptorMap.get(resource);
        if(descriptor==null)
        {
            URL url= FeedPlugin.getDefault().getBundle().getEntry(resource);
            descriptor = ImageDescriptor.createFromURL(url);
            
            descriptorMap.put(resource, descriptor);
        }
        return descriptor;
    }
    
}
