package biz.junginger.newsfeed.eclipse;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/**
 * the help class to write logger
 * 
 * @author jma, mj
 * 
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - Added new function to allow DebugMode settings
 */

public class Logger {

	private Logger() {
	}

	public static void log(IStatus status) {
		FeedPlugin plugin = FeedPlugin.getDefault();
		if (plugin != null && plugin.getLog() != null) {
			plugin.getLog().log(status);
		} else {
			System.err.println("Could not log: " + status.getMessage());
		}
	}

	public static void log(int code, String msg, Throwable th) {
		log(new Status(code, FeedPlugin.ID, code, msg, th));
	}

	public static void error(String message) {
		log(IStatus.ERROR, message, null);
	}

	public static void error(Throwable e) {
		log(IStatus.ERROR, getMessage(e), e);
	}

	public static void error(String message, Throwable e) {
		log(IStatus.ERROR, message, e);
	}

	public static void warn(String message) {
		log(IStatus.WARNING, message, null);
	}

	public static void warn(String message, Throwable e) {
		log(IStatus.WARNING, message, e);
	}

	public static void info(String message) {
		log(IStatus.INFO, message, null);
	}

	public static void info(String message, Throwable th) {
		log(IStatus.INFO, message, th);
	}

	public static String getMessage(Throwable e) {
		String msg = e.getMessage();
		return (msg != null) ? msg : e.getClass().getName();
	}
	
	public static int getDebugMode(){
		try {
			String mode = Platform.getDebugOption(FeedPlugin.ID + "/debugmode"); //$NON-NLS-1$
			if (mode != null && Integer.decode(mode).intValue() > 0) {
				return Integer.decode(mode).intValue();
			}
		} catch (NumberFormatException e) { /* ignored on purpose */ }

		return 0;
	}
}
