// Created on 19.03.2005
package biz.junginger.newsfeed.eclipse;

import org.eclipse.jface.action.Action;

import biz.junginger.newsfeed.ExceptionHistory;
import biz.junginger.plugin.common.UrlOpener;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - changed printStackTrace() to logged error
 */

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class OpenUrlAction extends Action
{
    private String url;
    private final UrlOpener urlOpener;

    public OpenUrlAction(UrlOpener urlOpener, String url, String text)
    {
        this.urlOpener = urlOpener;
        this.url = url;
        setText(text);
    }    
    
     public String getUrl()
    {
        return url;
    }
     
    public void setUrl(String url)
    {
        this.url = url;
    }

	public void run() {

		Runnable linkThread=new Runnable()
		{
		    public void run()
		    {
		        try
		        {
                    urlOpener.openUrl(url);
		        } catch (Exception ex)
		        {
		        	Logger.error("Could not open url.", ex); //$NON-NLS-1$
                    ExceptionHistory.getInstance().add(ex, url);                    
		        }	            
		    }
		};
		new Thread(linkThread).start();	    
	}

}
