// Created on 19.02.2006
package biz.junginger.newsfeed.eclipse;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import biz.junginger.newsfeed.eclipse.prefs.PrefsConstants;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ViewModeAction extends Action {
    
    private Menu menu;
    private MenuItem sortedByTimeMenuItem;
    private MenuItem groupedByTimeMenuItem;
    private MenuItem groupedByFeedMenuItem;
    private MenuItem groupedByFeedKeepSeqMenuItem;
    private final IPreferenceStore preferenceStore;

    public ViewModeAction(Composite parent, IPreferenceStore preferenceStore)
    {
        this.preferenceStore = preferenceStore;
        setImageDescriptor(ImageBank.getInstance().getImageDescriptor(ImageBank.MONITOR_VIEW));
        setToolTipText("Change view");
        
        menu = new Menu(parent);
        sortedByTimeMenuItem=createMenuItem("Sorted by time", PrefsConstants.VALUE_VIEW_MODE_SORTED_BY_TIME);
        groupedByTimeMenuItem=createMenuItem("Grouped by time", PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_TIME);
        groupedByFeedMenuItem=createMenuItem("Grouped by feed, sorted by time", PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED);
        groupedByFeedKeepSeqMenuItem=createMenuItem("Grouped by feed", PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED_KEEP_SEQ);
        updateSelection();
        
        IMenuCreator creator = createMenuCreator();
        setMenuCreator(creator);
    }

    private IMenuCreator createMenuCreator()
    {
        IMenuCreator creator = new IMenuCreator() {
            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
            
        };
        return creator;
    }

    //TODO call it
    public void dispose() {
        menu.dispose();
    }

    private MenuItem createMenuItem(String text, String mode)
    {
        MenuItem  item= new MenuItem(menu, SWT.CHECK|SWT.SINGLE);
        item.setText(text);
        item.addSelectionListener(new MySelectionAdapter(mode));
        return item;
    }

    public void run() {
        selectNextViewMode();
    }
    
    private class MySelectionAdapter extends SelectionAdapter {
        private final String mode;

        MySelectionAdapter(String mode){
            this.mode = mode;
        }

        public void widgetSelected(SelectionEvent e) {
            selectNewViewMode(mode);
        }
        
    }
    
    private void updateSelection() {
        String mode = getViewMode();
        sortedByTimeMenuItem.setSelection(PrefsConstants.VALUE_VIEW_MODE_SORTED_BY_TIME.equals(mode));
        groupedByTimeMenuItem.setSelection(PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_TIME.equals(mode));
        groupedByFeedMenuItem.setSelection(PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED.equals(mode));
        groupedByFeedKeepSeqMenuItem.setSelection(PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED_KEEP_SEQ.equals(mode));
    }
    
    private void selectNewViewMode(String mode)
    {
        preferenceStore.setValue(PrefsConstants.VIEW_MODE,mode);
        updateSelection();
    }

    private void selectNextViewMode()
    {
        String mode = getViewMode();
        String nextMode;
        if(PrefsConstants.VALUE_VIEW_MODE_SORTED_BY_TIME.equals(mode)) {
            nextMode=PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_TIME;
        } else if(PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_TIME.equals(mode)) {
            nextMode=PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED;
        } else if(PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED.equals(mode)) {
            nextMode=PrefsConstants.VALUE_VIEW_MODE_GROUPED_BY_FEED_KEEP_SEQ;
        } else {
            nextMode=PrefsConstants.VALUE_VIEW_MODE_SORTED_BY_TIME;
        }
        selectNewViewMode(nextMode);
    }

    private String getViewMode()
    {
        String mode = preferenceStore.getString(PrefsConstants.VIEW_MODE);
        return mode;
    }    
    
}
