// Created on 08.04.2005
package biz.junginger.newsfeed.eclipse.prefs;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import biz.junginger.newsfeed.eclipse.ImageBank;
import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelSettings;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class FeedEditor
{
    private TableViewer viewer;

    private TableColumn column1;

    private TableColumn column2;

    private Table table;

    private TableColumn column3;

    private final String[] colProps = { "active", "url", "time" };

    private List channelSettings;

    public FeedEditor(Composite parent)
    {
        int style = SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
        viewer = new TableViewer(parent, style);

        // channelSettings=RssPlugin.getDefault().createChannelSettings();

        table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        viewer.setColumnProperties(colProps);

        column1 = new TableColumn(table, SWT.CENTER);
        column2 = new TableColumn(table, SWT.LEFT);
        column3 = new TableColumn(table, SWT.CENTER);
        column1.setText("On");
        column1.pack();
        column1.setResizable(false);

        column2.setText("RSS feed URL");
        column2.setWidth(300);

        column3.setText("Update [min]");
        column3.pack();

        viewer.setContentProvider(new MyContentProvider());
        viewer.setLabelProvider(new MyLabelProvider());
        // viewer.setInput("MyInput");

        CellEditor[] editors = new CellEditor[3];
        editors[0] = new CheckboxCellEditor(table);
        editors[1] = new TextCellEditor(table);

        TextCellEditor updateEditor = new TextCellEditor(table);
        updateEditor.setStyle(SWT.CENTER);
        ((Text) updateEditor.getControl()).setTextLimit(10);
        editors[2] = updateEditor;

        viewer.setCellEditors(editors);
        viewer.setCellModifier(new MyCellModifier());

        recalcLayout();
    }

    public void recalcLayout()
    {
        Runnable uiUpdater = new Runnable()
        {
            public void run()
            {
                viewer.refresh();
                // column1.pack();
                // column2.pack();
                // column3.pack();
                // viewer.refresh();
                // table.pack();
            }
        };
        Table table = viewer.getTable();
        if (table.isDisposed())
            return;
        table.getDisplay().asyncExec(uiUpdater);
    }

    class MyCellModifier implements ICellModifier
    {
        public boolean canModify(Object element, String property)
        {
            return true;
        }

        public Object getValue(Object element, String property)
        {
            if (!(element instanceof ChannelSettings))
                return "";
            ChannelSettings settings = (ChannelSettings) element;
            if (property.equals(colProps[0]))
                return new Boolean(settings.isActive());
            else if (property.equals(colProps[1]))
                return settings.getUrl();
            else if (property.equals(colProps[2])) {
                int min = settings.getUpdateIntervalMinutes();
                if (min < 1)
                    return "";
                return "" + min;
            } else
                return "?";
        }

        public void modify(Object element, String property, Object value)
        {
            if (!(element instanceof TableItem))
                return;
            Object data = ((TableItem) element).getData();
            if (!(data instanceof ChannelSettings))
                return;
            ChannelSettings settings = (ChannelSettings) data;
            if (property.equals(colProps[0])) {
                if (value instanceof Boolean)
                    settings.setActive(((Boolean) value).booleanValue());
                else
                    Logger.error("Invalid value: " + value);
            } else if (property.equals(colProps[1])) {
                if (value instanceof String)
                    settings.setUrl((String) value);
                else
                    Logger.error("Invalid value: " + value);
            } else if (property.equals(colProps[2])) {
                if (value instanceof String) {
                    int min;
                    if (value.equals(""))
                        min = 0;
                    else {
                        try {
                            min = Integer.parseInt(value.toString());
                        } catch (Exception e) {
                            return;
                        }
                    }
                    if (min < 0)
                        min = 0;
                    settings.setUpdateIntervalMinutes(min);

                } else
                    Logger.error("Invalid value: " + value);
            }
            viewer.refresh();
        }

    }

    class MyContentProvider implements IStructuredContentProvider
    {
        public void inputChanged(Viewer v, Object oldInput, Object newInput)
        {
        }

        public void dispose()
        {
        }

        public Object[] getElements(Object parent)
        {
            return channelSettings.toArray();
        }
    }

    static class MyLabelProvider extends LabelProvider implements ITableLabelProvider
    {
        private Image on;

        private Image off;

        public MyLabelProvider()
        {
            ImageBank bank = ImageBank.getInstance();
            on = bank.createImage(ImageBank.CHECKBOX_ON);
            off = bank.createImage(ImageBank.CHECKBOX_OFF);
        }

        public void dispose()
        {
            if (on != null)
                on.dispose();
            if (off != null)
                off.dispose();
            super.dispose();
        }

        public String getColumnText(Object obj, int index)
        {
            if (!(obj instanceof ChannelSettings))
                return "?";

            ChannelSettings settings = (ChannelSettings) obj;
            if (index == 0)
                return "";
            else if (index == 1)
                return settings.getUrl();
            else if (index == 2) {
                int min = settings.getUpdateIntervalMinutes();
                if (min < 1)
                    return "default";
                return "" + min;
            }

            return "?";
        }

        public Image getColumnImage(Object obj, int index)
        {
            if (index == 0 && obj instanceof ChannelSettings) {
                boolean active = ((ChannelSettings) obj).isActive();
                if (active)
                    return on;
                return off;
            }
            return null;
        }
    }

    public void addNewRow()
    {
        ChannelSettings settings = new ChannelSettings();
        channelSettings.add(settings);
        viewer.refresh();
    }

    public void removeCurrentRow()
    {
        ChannelSettings channelSetting = getSelectedChannelSetting();
        if (channelSetting != null) {
            channelSettings.remove(channelSetting);
            viewer.refresh();
        }
    }

    private ChannelSettings getSelectedChannelSetting()
    {
        TableItem[] selection = table.getSelection();
        if (selection == null || selection.length == 0)
            return null;

        return (ChannelSettings) selection[0].getData();
    }

    public void setLayoutData(Object layoutData)
    {
        table.setLayoutData(layoutData);
    }

    public List getChannelSettings()
    {
        return channelSettings;
    }

    public void setChannelSettings(List channelSettings)
    {
        this.channelSettings = channelSettings;
        viewer.setInput(channelSettings);
    }

    private void moveCurrentSelection(int offset)
    {
        ChannelSettings channelSetting = getSelectedChannelSetting();
        if (channelSetting != null) {
            int index = channelSettings.indexOf(channelSetting);
            int newIndex = index + offset;
            if (newIndex >= 0 && newIndex < channelSettings.size()) {
                channelSettings.remove(index);
                channelSettings.add(newIndex, channelSetting);
                viewer.refresh();
            }
        }
    }

    public void moveUpCurrentRow()
    {
        moveCurrentSelection(-1);
    }

    public void moveDownCurrentRow()
    {
        moveCurrentSelection(1);
    }
}
