package biz.junginger.newsfeed.eclipse.prefs;

import java.util.ArrayList;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import biz.junginger.newsfeed.eclipse.FeedPlugin;
import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelSettings;

/**
 * Class used to initialize default preference values.
 */
/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - disabled default channels
 */

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class FeedPreferenceInitializer extends AbstractPreferenceInitializer
{

    /**
     * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
     */
    public void initializeDefaultPreferences()
    {
        IPreferenceStore store = FeedPlugin.getDefault().getPreferenceStore();

        store.setDefault(PrefsConstants.DEFAULT_UPDATE_INTERVAL, 5);
        store.setDefault(PrefsConstants.SHOW_HEADLINE_IN_TOOLTIP, true);
        store.setDefault(PrefsConstants.CHANGE_ICON_SYNC, true);
        String channels;
        // commented out because we do not want to see the default channels
        /* String german = Locale.GERMAN.getLanguage();
        String defaultLanguage = Locale.getDefault().getLanguage();
        if (german.equals(defaultLanguage)) {
            channels = createDefaultChannelSettingsDe();
        } else {
            channels = createDefaultChannelSettingsEn();
        }
        store.setDefault(PrefsConstants.RSS_CHANNELS, channels);*/

        store.setDefault(PrefsConstants.AVAILABLE_OFFLINE, true);
        store.setDefault(PrefsConstants.BROWSER, PrefsConstants.VALUE_BROWSER_INTERNAL_SINGLE);
    }

    private String createDefaultChannelSettingsDe()
    {
        ArrayList list = new ArrayList();

        ChannelSettings ch1 = new ChannelSettings();
        ch1.setActive(true);
        ch1.setUrl("http://jars.de/feed");
        ch1.setUpdateIntervalMinutes(90);
        list.add(ch1);

        ChannelSettings ch2 = new ChannelSettings();
        ch2.setActive(true);
        ch2.setUrl("http://webthreads.de/feed");
        ch2.setUpdateIntervalMinutes(90);
        list.add(ch2);
        
        ChannelSettings ch3 = new ChannelSettings();
        ch3.setActive(true);
        ch3.setUrl("http://feeds.feedburner.com/groovymovie-top-heute");
        ch3.setUpdateIntervalMinutes(180);
        list.add(ch3);

        try {
            String str = FeedSettingsMemento.createXmlMementoString(list);
            return str;
        } catch (Exception e) {
        	Logger.error("Could not create XMLMementoString", e); //$NON-NLS-1$
            return null;
        }
    }

    private String createDefaultChannelSettingsEn()
    {
        ArrayList list = new ArrayList();

        ChannelSettings ch1 = new ChannelSettings();
        ch1.setActive(true);
        ch1.setUrl("http://feeds.feedburner.com/jars-english");
        ch1.setUpdateIntervalMinutes(90);
        list.add(ch1);

        try {
            String str = FeedSettingsMemento.createXmlMementoString(list);
            return str;
        } catch (Exception e) {
        	Logger.error("Could not create XMLMementoString", e); //$NON-NLS-1$
            return null;
        }
    }

}
