// Created on 08.04.2005
package biz.junginger.newsfeed.eclipse.prefs;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

import biz.junginger.newsfeed.ExceptionHistory;
import biz.junginger.newsfeed.eclipse.Logger;
import biz.junginger.newsfeed.model.ChannelSettings;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - added cancelable ProgressMonitor
 */

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class FeedSettingsMemento
{
	public static final String TAG_ROOT="rss-channel-settings";
	public static final String TAG_CHANNEL="channel";
	public static final String TAG_URL="url";
	public static final String TAG_ACTIVE="active";
	public static final String TAG_FILTER_AGE_MINUTE="filter-age-minutes";
	public static final String TAG_UPDATE_INTERVAL_MINUTES="update-interval-minutes";

	static public XMLMemento createMemento(List list)
	{
		XMLMemento memento = XMLMemento.createWriteRoot(TAG_ROOT);

		if(list!=null) {
			Iterator it=list.iterator();
			while (it.hasNext())
			{
				ChannelSettings settings = (ChannelSettings) it.next();
				IMemento settingsMemento = memento.createChild(TAG_CHANNEL);
				settingsMemento.putString(TAG_URL,settings.getUrl());
				int act=settings.isActive()? 1: 0;
				settingsMemento.putInteger(TAG_ACTIVE,act);
				settingsMemento.putInteger(TAG_FILTER_AGE_MINUTE,settings.getFilterAgeMinutes());
				settingsMemento.putInteger(TAG_UPDATE_INTERVAL_MINUTES,settings.getUpdateIntervalMinutes());
			}
		}

		return memento;
	}

	public static String createXmlMementoString(List list) throws IOException
	{
		XMLMemento memento = createMemento(list);
		Writer writer = new StringWriter();
		memento.save(writer);
		writer.close();
		return writer.toString();
	}


	public static List restoreFromXmlMementoString(String xmlString, IProgressMonitor monitor)
	{
		ArrayList list = new ArrayList();
		try {
			if(xmlString.length() > 0){
			StringReader reader = new StringReader(xmlString);

			XMLMemento memento = XMLMemento.createReadRoot(reader);
			IMemento[] settingsMementos = memento.getChildren(TAG_CHANNEL);
			for (int i = 0; i < settingsMementos.length; i++)
			{   
				if(!monitor.isCanceled()) {
					IMemento mem = settingsMementos[i];
					String url = mem.getString(TAG_URL);
					Integer act = mem.getInteger(TAG_ACTIVE);
					Integer filter = mem.getInteger(TAG_FILTER_AGE_MINUTE);
					Integer update = mem.getInteger(TAG_UPDATE_INTERVAL_MINUTES);

					ChannelSettings setting = new ChannelSettings();
					setting.setUrl(url);
					if(act!=null) setting.setActive(act.intValue()!=0);
					if(filter!=null) setting.setFilterAgeMinutes(filter.intValue());
					if(update!=null) setting.setUpdateIntervalMinutes(update.intValue());
					list.add(setting);
				}
				else {
					return list;
				}
			}
			}
		} catch(Throwable th) {
			Logger.error("RSS View error: Could not restore Channels - a new empty list is created.", th);
			Logger.error("RSS View debug - XML Memento String was: "+xmlString);
			ExceptionHistory.getInstance().add(th, "restoreFromXmlMementoString");
		}
		return list;
	}



}
