// Created on 08.04.2005
package biz.junginger.newsfeed.eclipse.prefs;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

import biz.junginger.newsfeed.model.ChannelSettings;

//TODO check if still needed in future
/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ManualFilterMemento
{
    public static final String TAG_ROOT="rss-manual-filter";
    public static final String TAG_ITEM="item";
    public static final String TAG_ITEM_ID="item-id";
    
    static public XMLMemento createMemento(List list)
    {
        XMLMemento memento = XMLMemento.createWriteRoot(TAG_ROOT);
        
        Iterator it=list.iterator();
        while (it.hasNext())
        {
            ChannelSettings settings = (ChannelSettings) it.next();
            IMemento settingsMemento = memento.createChild(TAG_ITEM);
            settingsMemento.putString(TAG_ITEM_ID,settings.getUrl());
        }
        
        return memento;
    }
    
    public static String createXmlMementoString(List list) throws IOException
    {
        XMLMemento memento = createMemento(list);
        Writer writer = new StringWriter();
        memento.save(writer);
        writer.close();
        return writer.toString();
    }
    
    
    public static List restoreFromXmlMementoString(String xmlString) throws Exception
    {
        ArrayList list = new ArrayList();
        StringReader reader = new StringReader(xmlString);
        XMLMemento memento = XMLMemento.createReadRoot(reader);
        IMemento[] settingsMementos = memento.getChildren(TAG_ITEM);
        for (int i = 0; i < settingsMementos.length; i++)
        {   
            IMemento mem = settingsMementos[i];
            String id = mem.getString(TAG_ITEM_ID);
            list.add(id);
        }
        return list;
    }
    
    
    
}
