// Created on 18.02.2006
package biz.junginger.newsfeed.model;

import java.util.Date;

import org.eclipse.swt.graphics.Image;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public abstract class ChannelCommon
{
    private String title;
    private String description;
    private String link;
    private String publishDateStr;
    private Date publishDate;
    private String updatedDateStr;
    private Date updatedDate;
    
    
    public String getDescription()
    {
        return description;
    }
    public void setDescription(String description)
    {
        this.description = description;
    }
    public String getLink()
    {
        return link;
    }
    public void setLink(String link)
    {
        this.link = link;
    }
    public Date getPublishDate()
    {
        return publishDate;
    }
    public void setPublishDate(Date publishDate)
    {
        this.publishDate = publishDate;
    }
    public String getPublishDateStr()
    {
        return publishDateStr;
    }
    public void setPublishDateStr(String publishDateStr)
    {
        this.publishDateStr = publishDateStr;
    }
    public String getTitle()
    {
        return title;
    }
    public void setTitle(String title)
    {
        this.title = title;
    }
    public Date getUpdatedDate()
    {
        return updatedDate;
    }
    public void setUpdatedDate(Date updatedDate)
    {
        this.updatedDate = updatedDate;
    }
    public String getUpdatedDateStr()
    {
        return updatedDateStr;
    }
    public void setUpdatedDateStr(String updatedDateStr)
    {
        this.updatedDateStr = updatedDateStr;
    }
    
    public abstract Image getImage();

    public Date getRelevantDate() {
        if(updatedDate!=null) {
            return updatedDate;
        } else {
            return publishDate;
        }
    }
    
    
    
}
