// Created on 15.03.2005
package biz.junginger.newsfeed.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.Image;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ChannelContent extends ChannelCommon
{
    private List rssItems;
    private String sourceUrl;
    private Image icon16;
    
    public ChannelContent()
    {
        rssItems=new ArrayList();
    }
    
    public Image getIcon16()
    {
        return icon16;
    }
    
    public void setIcon16(Image icon16)
    {
        this.icon16 = icon16;
    }
    
    public List getChannelItems()
    {
        return rssItems;
    }
    
    public void addRssItem(ChannelItem item)
    {
        rssItems.add(item);
    }
    
    public Iterator getRssItemIterator()
    {
        return rssItems.iterator();
    }

    public Image getImage()
    {
        return icon16;
    }
    
    public Date getRelevantDate() {
        Date date=null;
        if(!rssItems.isEmpty()) {
            ChannelItem item = (ChannelItem) rssItems.get(0);
            if(item!=null) {
                date=item.getRelevantDate();
            }
        } 
        if(date==null) {
            date=super.getRelevantDate();
        }
        return date;
    }

    public String getSourceUrl()
    {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl)
    {
        this.sourceUrl = sourceUrl;
    }
    
}
