// Created on 17.02.2006
package biz.junginger.newsfeed.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ChannelModel
{
    private List channelSettings;
    private Map updateMillisMap;
    private Map channelContentMap;
    private List listeners;

    public ChannelModel()
    {
        updateMillisMap = new HashMap();
        channelContentMap = new HashMap();
        listeners = new ArrayList();
    }

    public synchronized void addChannelModelListener(ChannelModelListener listener)
    {
        listeners.add(listener);
    }

    public synchronized void removeChannelModelListener(ChannelModelListener listener)
    {
        listeners.remove(listener);
    }

    public long getLastUpdateMillis(String url)
    {
        Object obj = updateMillisMap.get(url);
        if (obj instanceof Long)
            return ((Long) obj).longValue();
        else
            return 0;
    }

    public void setLastUpdateMillis(String url)
    {
        Long value = new Long(System.currentTimeMillis());
        updateMillisMap.put(url, value);
    }

    public synchronized Set getAllActiveUrls()
    {
        Set urls = new HashSet();
        if(channelSettings!=null) {
            Iterator it = channelSettings.iterator();
            while (it.hasNext()) {
                ChannelSettings settings = (ChannelSettings) it.next();
                if (settings.isActive()) {
                    urls.add(settings.getUrl());
                }
            }
        }
        return urls;
    }

    public synchronized void updateChannelContent(String url, ChannelContent content)
    {
        channelContentMap.put(url, content);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ChannelModelListener listener = (ChannelModelListener) iterator.next();
            listener.updatedChannelContent(content);
        }
    }

    public synchronized void setChannelSettings(List channelSettings)
    {
        this.channelSettings = channelSettings;
        Set activeUrls = getAllActiveUrls();
        removeChannelContentNotInSet(activeUrls);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ChannelModelListener listener = (ChannelModelListener) iterator.next();
            listener.changedChannelSettings();
        }
        resetAllUpdateTimes(); // ?? why ??
    }

    public synchronized List getSettingsCopy()
    {
        if (channelSettings == null) {
            return null;
        }
        return new ArrayList(channelSettings);
    }

    public synchronized ChannelContent[] createChannelArray()
    {
        Collection channelCol = channelContentMap.values();
        ChannelContent[] channels = new ChannelContent[0];
        channels=(ChannelContent[]) channelCol.toArray(channels);
        return channels;
    }

    public synchronized List createChannelList()
    {
        Collection channelCol = channelContentMap.values();
        return new ArrayList(channelCol);
    }

    public synchronized void removeChannelContentNotInSet(Set urls)
    {
        Set keys = channelContentMap.keySet();
        Iterator it = keys.iterator();

        while (it.hasNext()) {
            String url = (String) it.next();
            if (!urls.contains(url))
                it.remove();
        }
    }

    public void resetAllUpdateTimes()
    {
        updateMillisMap.clear();
    }

}
