// Created on 08.04.2005
package biz.junginger.newsfeed.model;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class ChannelSettings
{
    private String url;
    private int updateIntervalMinutes;
    private int filterAgeMinutes;
    private boolean active;
    
    private String errorMessage;
    private Throwable exception;
    private long errorTime;
    
    
    public ChannelSettings()
    {
        url="";
    }
    
    public Throwable getException()
    {
        return exception;
    }

    public void setException(Throwable exception)
    {
        this.exception = exception;
    }
    
    public boolean isActive()
    {
        return active;
    }
    public void setActive(boolean active)
    {
        this.active = active;
    }
    
    public int getFilterAgeMinutes()
    {
        return filterAgeMinutes;
    }
    public void setFilterAgeMinutes(int filterAgeMinutes)
    {
        this.filterAgeMinutes = filterAgeMinutes;
    }
    
    public int getUpdateIntervalMinutes()
    {
        return updateIntervalMinutes;
    }
    public void setUpdateIntervalMinutes(int updateEveryMinutes)
    {
        this.updateIntervalMinutes = updateEveryMinutes;
    }
    
    public String getUrl()
    {
        return url;
    }
    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getErrorMessage()
    {
        return errorMessage;
    }

    public void setError(String errorMessage, Throwable ex)
    {
        this.errorMessage = errorMessage;
        exception=ex;
        errorTime=System.currentTimeMillis();
    }
    
    public void clearError()
    {
        errorMessage = null;
        exception=null;
        errorTime=0;
    }
    
    public boolean hasError()
    {
        return errorTime != 0;
    }

    public long getErrorTime()
    {
        return errorTime;
    }

    public void setErrorTime(long errorTime)
    {
        this.errorTime = errorTime;
    }
}
