// Created on 17.02.2006
package biz.junginger.newsfeed.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class CachedHttpContent
{
    private HttpContent httpContent;
    private URL url;
    private final MyFileCache cache;
    private byte[] bytes; 
    

    public CachedHttpContent(MyFileCache cache, String urlStr) throws MalformedURLException
    {
        this(cache, new URL(urlStr));
    }
    
    public CachedHttpContent(MyFileCache cache, URL url) throws MalformedURLException
    {
        this.cache = cache;
        this.url=url;
        httpContent=new HttpContent(url);
    }

    public void doRequest() throws IOException
    {
        try {
            httpContent.doRequest();
            bytes=httpContent.getBytes();
            storeInCache();
        }
        catch(UnexpectedHttpResponseCodeException codeEx) {
            throw codeEx; //TODO try if cache is valid
        }
        catch(IOException ex) {
            tryToUseCache(ex);
        }
    }

    private void storeInCache()
    {
        if(cache==null) {
            return;
        }
        cache.store(url.toString(), getBytes());
    }

    private void tryToUseCache(IOException ex) throws IOException
    {
        byte[] cached =null;
        if(cache!=null) {
            cached=cache.retrieve(url.toString());
        }
        if(cached==null) {
            throw ex;
        }
        bytes=cached;
    }

    public byte[] getBytes()
    {
        return bytes;
    }

    public void setIfModifiedSinceMillis(long ifModifiedSinceMillis)
    {
        httpContent.setIfModifiedSinceMillis(ifModifiedSinceMillis);
    }

}
