// Created on 24.04.2005
package biz.junginger.newsfeed.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

import biz.junginger.newsfeed.Constants;
import biz.junginger.newsfeed.eclipse.Logger;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - changed printStackTrace() to logged error
 */

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class HttpContent
{
    private URL url;

    private long ifModifiedSinceMillis;

    private boolean modified;

    private byte[] bytes;

    private int responseCode;

    public HttpContent(String urlStr) throws MalformedURLException
    {
        this(new URL(urlStr));
    }

    public HttpContent(URL url) throws MalformedURLException
    {
        this.url = url;
    }

    public void doRequest() throws IOException
    {
        URLConnection connection = url.openConnection();

        if (ifModifiedSinceMillis > 0) {
            connection.setIfModifiedSince(ifModifiedSinceMillis);
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection) connection;
            String os = "unkown";
            try {
                Properties prop = System.getProperties();
                os = prop.getProperty("os.arch") + "; " + prop.getProperty("os.name");
            } catch (Throwable th) {
            	Logger.error("Could not get property 'os.arch'.", th); //$NON-NLS-1$
            }
            checkForBasicAuthentication(httpConnection);
            httpConnection.setRequestProperty("User-Agent", "RSS View " + Constants.CURRENT_VERSION + " (" + os + ")");
        }
        connection.connect();

        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection) connection;
            responseCode = httpConnection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_NOT_MODIFIED) {
                modified = false;
            } else if (responseCode == 200) {
                modified = true;
            } else {
                throw new UnexpectedHttpResponseCodeException("HTTP code " + responseCode + " returned from " + url);
            }
        } else {
            modified = true;
        }

        readAllBytes(connection);
    }

    private void checkForBasicAuthentication(HttpURLConnection httpConnection)
    {
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            int arobase = authority.lastIndexOf('@');
            if (arobase != -1) {
                authority = authority.substring(0, arobase);
                String encoding = new sun.misc.BASE64Encoder().encode(authority.getBytes());
                httpConnection.setRequestProperty("Authorization", "Basic " + encoding);
            }
        }
    }

    private void readAllBytes(URLConnection connection) throws IOException
    {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        InputStream in = connection.getInputStream();
        try {
            while (true) {
                int read = in.read(buffer);
                if (read == -1)
                    break;
                byteOut.write(buffer, 0, read);
            }
        } finally {
            in.close();
        }
        bytes = byteOut.toByteArray();
    }

    public void setIfModifiedSinceMillis(long ifModifiedSinceMillis)
    {
        this.ifModifiedSinceMillis = ifModifiedSinceMillis;
    }

    public byte[] getBytes()
    {
        return bytes;
    }

    public void setBytes(byte[] bytes)
    {
        this.bytes = bytes;
    }

    public int getResponseCode()
    {
        return responseCode;
    }

}
