// Created on 17.02.2006
package biz.junginger.newsfeed.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import biz.junginger.newsfeed.ExceptionHistory;
import biz.junginger.newsfeed.eclipse.Logger;

//TODO use an index file here
/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */

/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License version
2.1 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the Lesser GNU General Public License version 2.1
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/* Contributor: 
 * Caroline Rieder (Wind River) - removed channel refresh when opening the preference page
 * Caroline Rieder (Wind River) - changed printStackTrace() to logged error
 */

/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class MyFileCache
{
    private File rootDir;
    private boolean active;

    public MyFileCache(File rootDir) throws IOException
    {
        if (!rootDir.exists()) {
            boolean ok = rootDir.mkdirs();
			if(Logger.getDebugMode() > 0){
				Logger.info("Created dir OK: " + ok + " - " + rootDir.getCanonicalPath());
			}
        }
        if (!rootDir.isDirectory()) {
            throw new IOException("Not a directory: " + rootDir);
        }
        this.rootDir = rootDir;
    }

    private String encode(String string)
    {
        string=string.replace('.', '_');
        try {
            String encoded = URLEncoder.encode(string, "ISO-8859-1");
            //TODO there seems to be an limit of 100 chars?? Check this!!
            if(encoded.length()>100) {
                Logger.warn("Warning: file cache shortend id - potential collision (should be rare though) for URL "+string.substring(0, 40)+"...");
                encoded=encoded.substring(0,100);
            }
            return encoded;
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void storeOrThrow(String id, byte[] data) throws IOException
    {
        if(!active) {
            return;
        }
        File file = getCacheFile(id);
        OutputStream out= new FileOutputStream(file);
        //out = new GZIPOutputStream(out);
        try{
            out.write(data);
            out.flush();
        }
        finally{out.close();}
    }

    public synchronized void store(String id, byte[] data)
    {
        try {
            storeOrThrow(id, data);
        } catch (IOException ex) {
        	Logger.error("Could not store cache.", ex);
            ExceptionHistory.getInstance().add(ex, getClass().getName());
        }
    }

    private File getCacheFile(String id)
    {
        String encodedFileName = encode(id);
        File file = new File(rootDir, encodedFileName);
//        String absolutePath = file.getAbsolutePath();
        return file;
    }

    public byte[] retrieve(String id)
    {
        try {
            return retrieveOrThrow(id);
        } catch (FileNotFoundException ex) {
        } catch (IOException ex) {
        	Logger.error("Could not find id.", ex);
            ExceptionHistory.getInstance().add(ex, getClass().getName());
        }
        return null;
    }

    public synchronized byte[] retrieveOrThrow(String id) throws IOException
    {
        if(!active) {
            return null;
        }
        File file = getCacheFile(id);

        InputStream in = new FileInputStream(file);
        //in = new GZIPInputStream(in);
        try {
            byte[] buffer = new byte[512];
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            while (true) {
                int read = in.read(buffer);
                if (read == -1)
                    break;
                byteOut.write(buffer, 0, read);
            }
            return byteOut.toByteArray();
        } finally {
            in.close();
        }
    }

    public synchronized void clearAll()
    {
        File[] files = rootDir.listFiles();
        if(files!=null) {
            for (int i = 0; i < files.length; i++) {
                files[i].delete();
            }
        }
    }

    public boolean isActive()
    {
        return active;
    }

    public void setActive(boolean active)
    {
        this.active = active;
    }
}
