// Created on 03.11.2005
package biz.junginger.newsfeed.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import biz.junginger.newsfeed.model.ChannelCommon;
import biz.junginger.newsfeed.model.ChannelContent;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public abstract class FeedParser
{
    private SimpleDateFormat dateFormat1;
    private SimpleDateFormat dateFormat2;

    public FeedParser()
    {
        dateFormat1 = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
    }

    public abstract ChannelContent parseDocument(Document doc) throws Exception;

    protected void setDate(ChannelCommon item, String value, boolean isUpdated)
    {
        if (isUpdated) {
            item.setUpdatedDateStr(value);
        } else {
            item.setPublishDateStr(value);
        }
        Date date = parseTDateFormats(value);
        if(date==null) {
            date=parseTextDateFormat(value);
        }
        if(date!=null) {
            if (isUpdated) {
                item.setUpdatedDate(date);
            } else {
                item.setPublishDate(date);
            }            
        }
    }

    protected Date parseTextDateFormat(String value)
    {
        try {
            return dateFormat1.parse(value);
        } catch (ParseException e) {
            return null;

        } catch (RuntimeException e) {
            return null;
        }
    }

    // <dc:date>2005-04-24T13:30:00+00:00</dc:date>
    protected Date parseTDateFormats(String value)
    {
        try {
            if (value.length() == 25 && value.charAt(22) == ':') {
                // no colon in time zone
                value = value.substring(0, 22) + value.substring(23);
            } else if (value.length() == 20 && value.charAt(19) == 'Z') {
                // 2005-11-04T07:00:00Z
                value = value.substring(0, 19) + "+0000";
            }
            return dateFormat2.parse(value);
        } catch (ParseException e) {
            // e.printStackTrace();
            return null;
        }
    }

    protected String getTextValue(Node node)
    {
        if (node.getFirstChild() != null) {
            //String rawValue = node.getTextContent(); Java5 only
            NodeList kids = node.getChildNodes();
            int len = kids.getLength();
            StringBuffer buffer=null;
            for (int i = 0; i < len; i++) {
                String value = kids.item(i).getNodeValue();
                if(value!=null) {
                    if(buffer==null) {
                        buffer=new StringBuffer();
                    }
                    buffer.append(value);
                }
            }
            if (buffer != null) {
                return  buffer.toString().trim();
            }
        }
        return null;
    }

}
