// Created on 03.11.2005
package biz.junginger.newsfeed.parser;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import biz.junginger.newsfeed.model.ChannelContent;
import biz.junginger.newsfeed.model.ChannelItem;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public abstract class GenericItemFeedParser extends FeedParser
{
    protected void parseAllItemNodes(String itemTagName, Document doc, ChannelContent content)
    {
        NodeList itemNodes = doc.getElementsByTagName(itemTagName);
        int len = itemNodes.getLength();
        for(int i=0; i<len;i++)
        {
            Node node = itemNodes.item(i);

            ChannelItem item=parseItemNode(content, node);
            content.addRssItem(item);
        }
    }
    
    protected ChannelItem parseItemNode(ChannelContent content, Node itemNode)
    {
        ChannelItem item = new ChannelItem();
        item.setChannel(content);
        NodeList kids = itemNode.getChildNodes();
        int len = kids.getLength();
        for(int i=0; i<len;i++)
        {
            Node node = kids.item(i);
            parseItemSubNode(item, node);
        }        
        return item;
    }

    protected abstract void parseItemSubNode(ChannelItem item, Node node);

}
