// Created on 03.11.2005
package biz.junginger.newsfeed.parser;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import biz.junginger.newsfeed.model.ChannelCommon;
import biz.junginger.newsfeed.model.ChannelContent;
import biz.junginger.newsfeed.model.ChannelItem;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class RssFeedParser extends GenericItemFeedParser
{
    public ChannelContent parseDocument(Document doc) throws Exception
    {
        NodeList channelNodes = doc.getElementsByTagName("channel");
        int len1 = channelNodes.getLength();
        if(len1==0) throw new Exception("No channel elements in rss feed");
        Node channelNode = channelNodes.item(0);
        ChannelContent content = parseChannelNode(channelNode);
        parseAllItemNodes("item",doc, content);        
        return content;
    }

    private ChannelContent parseChannelNode(Node channelNode)
    {
        ChannelContent content = new ChannelContent();
        NodeList kids = channelNode.getChildNodes();
        int len = kids.getLength();
        for(int i=0; i<len;i++)
        {
            Node node = kids.item(i);
            parseRssNode(content, node);

        }
        return content;
    }

    protected void parseItemSubNode(ChannelItem item, Node node)
    {
        parseRssNode(item, node);
    }

    private void parseRssNode(ChannelCommon item, Node node)
    {
        String name=node.getNodeName();
        
        if("title".equalsIgnoreCase(name)) item.setTitle(getTextValue(node));
        else if("description".equalsIgnoreCase(name)) item.setDescription(getTextValue(node));
        else if("content:encoded".equalsIgnoreCase(name)) item.setDescription(getTextValue(node));
        else if("link".equalsIgnoreCase(name)) item.setLink(getTextValue(node));
        else if("pubDate".equalsIgnoreCase(name)) setDate(item, getTextValue(node),false);
        else if("dc:date".equalsIgnoreCase(name)) setDate(item, getTextValue(node), false);
        else if("updateDate".equalsIgnoreCase(name)) setDate(item, getTextValue(node),true);
    }


}
