// Created on 12.09.2006
package biz.junginger.newsfeed.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public abstract class DateUtils
{
    public static boolean isToday(Calendar cal) {
        GregorianCalendar today = new GregorianCalendar();
        boolean eq=
            (today.get(Calendar.YEAR)==cal.get(Calendar.YEAR)) &&
            (today.get(Calendar.MONTH)==cal.get(Calendar.MONTH)) &&
            (today.get(Calendar.DATE)==cal.get(Calendar.DATE));
        return eq;
    }

    public static boolean isToday(long millis) {
        Calendar cal =Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return isToday(cal);
    }

    public static boolean isToday(Date date) {
        Calendar cal =Calendar.getInstance();
        cal.setTime(date);
        return isToday(cal);
    }

}
