package biz.junginger.newsfeed.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * (C) Copyright 2004-2008 Markus Junginger.
 * 
 * @author Markus Junginger
 */
/*
 * This file is part of RSS View.
 * 
 * RSS View is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * RSS View is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with RSS View. If not, see <http://www.gnu.org/licenses/>.
 */
public class MapOfLists {
	private HashMap map;
	
	public MapOfLists() {
		map=new HashMap();
	}
	
	public synchronized List getListOrNull(Object key) {
		return (List) map.get(key);
	}
	public synchronized List getList(Object key) {
		List list=(List) map.get(key);
		if(list==null) {
			list=new ArrayList();
			map.put(key, list);
		}
		return list;
	}
	
	public synchronized void addToList(Object key, Object value) {
		List list = getList(key);
		list.add(value);
	}

	public synchronized boolean removeFromList(Object key, Object value) {
		List list = getListOrNull(key);
		if(list!=null ) {
			return list.remove(value);
		} else {
			return false;
		}
	}

	public synchronized boolean contains(Object key, Object value) {
		List list = getListOrNull(key);
		if(list!=null) {
			return list.contains(list);
		} else {
			return false;
		}
	}

	/** Returns a clone of the map and it's lists - used for concurrent access */
    public synchronized Map getMapCopy() {
        Map clone = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while(iterator.hasNext()) {
            Object key=iterator.next();
            List list=(List) map.get(key);
            if(list!=null) {
                ArrayList listClone = new ArrayList(list);
                clone.put(key, listClone);
            }
        }
        return clone;
    }
}
